**************************************************************************************************
*******************DIRECT EFFECTS OF DEBT COVENANTS - ANALYSIS ***********************************
*************************DATE: AUG 2022 **********************************************************
************************ AUTHOR: KIM NGUYEN ******************************************************
**************************************************************************************************

clear all
set more off
set maxvar 30000
set matsize 10000

//Load data for analysis
use "\\Output\covenants_analysis.dta", clear

//Set up panel
xtset id year, delta(1)

//Global control vars
global controlvars "Lassets Lrevenue Lcash Lgearing Ldebt"

//Baseline regressions
eststo m1: quietly xtreg Dinvestment i.Lcov $controlvars c.year#i.gics_sector, fe robust
eststo m2: quietly xtreg Dstaffexpenses i.Lcov $controlvars c.year#i.gics_sector, fe robust
eststo m3: quietly xtreg Dinvestment i.Ldisg $controlvars c.year#i.gics_sector, fe robust
eststo m4: quietly xtreg Dstaffexpenses i.Ldisg $controlvars c.year#i.gics_sector, fe robust
eststo m5: quietly xtreg Dinvestment i.Lpung $controlvars c.year#i.gics_sector, fe robust
eststo m6: quietly xtreg Dstaffexpenses i.Lpung $controlvars c.year#i.gics_sector, fe robust
esttab m1 m2 m3 m4 m5 m6 using "\\Output\Debt Covenants - Direct Effects.csv", se margin title(Regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps

//Robustness - Non-mining sample
preserve 
keep if nonmining==1
eststo m1: quietly xtreg Dinvestment i.Lcov $controlvars c.year#i.gics_sector, fe robust
eststo m2: quietly xtreg Dstaffexpenses i.Lcov $controlvars c.year#i.gics_sector, fe robust
eststo m3: quietly xtreg Dinvestment i.Ldisg $controlvars c.year#i.gics_sector, fe robust
eststo m4: quietly xtreg Dstaffexpenses i.Ldisg $controlvars c.year#i.gics_sector, fe robust
eststo m5: quietly xtreg Dinvestment i.Lpung $controlvars c.year#i.gics_sector, fe robust
eststo m6: quietly xtreg Dstaffexpenses i.Lpung $controlvars c.year#i.gics_sector, fe robust
esttab m1 m2 m3 m4 m5 m6 using "\\Output\Debt Covenants - Direct Effects - Non-mining.csv", se margin title(Regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps
restore

//Robustness - Large firms sample
preserve
keep if Lsme==0
eststo m1: quietly xtreg Dinvestment i.Lcov $controlvars c.year#i.gics_sector, fe robust
eststo m2: quietly xtreg Dstaffexpenses i.Lcov $controlvars c.year#i.gics_sector, fe robust
eststo m3: quietly xtreg Dinvestment i.Ldisg $controlvars c.year#i.gics_sector, fe robust
eststo m4: quietly xtreg Dstaffexpenses i.Ldisg $controlvars c.year#i.gics_sector, fe robust
eststo m5: quietly xtreg Dinvestment i.Lpung $controlvars c.year#i.gics_sector, fe robust
eststo m6: quietly xtreg Dstaffexpenses i.Lpung $controlvars c.year#i.gics_sector, fe robust
esttab m1 m2 m3 m4 m5 m6 using "\\Output\Debt Covenants - Direct Effects - Large firms.csv", se margin title(Regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps
restore

//Robustness - Removing firms never exposed to covenants
preserve
bysort year id: egen evercov = sum(cov)
drop if evercov==0
xtset id year, delta(1)
eststo m1: quietly xtreg Dinvestment i.Lcov $controlvars c.year#i.gics_sector, fe robust
eststo m2: quietly xtreg Dstaffexpenses i.Lcov $controlvars c.year#i.gics_sector, fe robust
eststo m3: quietly xtreg Dinvestment i.Ldisg $controlvars c.year#i.gics_sector, fe robust
eststo m4: quietly xtreg Dstaffexpenses i.Ldisg $controlvars c.year#i.gics_sector, fe robust
eststo m5: quietly xtreg Dinvestment i.Lpung $controlvars c.year#i.gics_sector, fe robust
eststo m6: quietly xtreg Dstaffexpenses i.Lpung $controlvars c.year#i.gics_sector, fe robust
esttab m1 m2 m3 m4 m5 m6 using "\\Output\Debt Covenants - Direct Effects - Removed firms never exposed.csv", se margin title(Regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps
